/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.css.TagSoupStyleSheetHandler;
import org.w3c.css.css.XMLStyleSheetHandler;
import org.w3c.css.parser.CssFouffa;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.PropertiesLoader;
import org.w3c.css.properties.css1.Css1Style;
import org.w3c.css.properties.css1.CssColor;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.HTTPURL;
import org.w3c.www.mime.MimeType;
import org.xml.sax.SAXException;

public class StyleSheetCom {
    ApplContext ac;
    String lang;
    String documentBase = "text";
    URL htmlURL;
    String file;
    int warningLevel = 2;
    PrintWriter out;
    String defaultmedium;
    String cssversion;
    String profile;
    String contenttype;
    static boolean showCSS = false;
    private Exception exception;

    public void htmlRequest() throws Exception {
        StyleSheet style = null;
        TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(this.htmlURL, this.ac);
        handler.parse(this.htmlURL);
        style = handler.getStyleSheet();
        if (style != null) {
            style.setType("text/html");
        }
        if (style != null) {
            style.findConflicts(this.ac);
            StyleSheetGenerator output = new StyleSheetGenerator(this.ac, this.file, style, this.documentBase, this.warningLevel);
            output.print(this.out);
        } else {
            System.err.println("No style sheet found in your HTML document");
        }
        this.ac.setInput("text/xml");
    }

    public void xmlRequest() throws Exception {
        StyleSheet style = null;
        XMLStyleSheetHandler handler = new XMLStyleSheetHandler(this.htmlURL, this.ac);
        handler.parse(this.htmlURL);
        style = handler.getStyleSheet();
        if (style != null) {
            style.setType("text/xml");
            style.findConflicts(this.ac);
        } else {
            System.err.println("No style sheet found in your HTML document");
        }
        StyleSheetGenerator output = new StyleSheetGenerator(this.ac, this.file, style, this.documentBase, this.warningLevel);
        output.print(this.out);
        this.ac.setInput("text/xml");
    }

    public void cssRequest(CssSelectors selector, String defaultmedium) {
        StyleSheetParser parser = new StyleSheetParser();
        this.ac.setMedium(defaultmedium);
        parser.parseURL(this.ac, this.htmlURL, null, null, null, 3);
        parser.getStyleSheet().findConflicts(this.ac);
        if (selector != null) {
            System.err.println("<color value=\"" + parser.getStyleSheet().CascadingOrder(new CssColor(), parser.getStyleSheet(), selector));
            CssStyle s = parser.getStyleSheet().getStyle(selector);
            CssColor _sl = ((Css1Style)s).getColor();
            s.print(new CssPrinterStyle(){

                public void print(CssProperty property) {
                    System.out.print(property.getPropertyName());
                    System.out.print(": ");
                    System.out.print(property.toString());
                    System.out.println(';');
                }
            });
        } else {
            StyleSheetGenerator output = new StyleSheetGenerator(this.ac, this.file, parser.getStyleSheet(), this.documentBase, this.warningLevel);
            output.print(this.out);
        }
    }

    public static void main(String[] args) throws IOException, MalformedURLException {
        int i;
        CssSelectors selector = null;
        StyleSheetCom style = new StyleSheetCom();
        style.contenttype = "text";
        try {
            style.file = args[i];
            for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
                String argument = args[i].substring(1).toLowerCase();
                if (argument.equals("e")) {
                    style.warningLevel = -1;
                    continue;
                }
                if (argument.equals("s")) {
                    showCSS = true;
                    continue;
                }
                if (argument.equals("c")) {
                    selector = StyleSheetCom.createSelectors(args[++i]);
                    continue;
                }
                if (argument.equals("format")) {
                    StyleSheetGenerator.printAvailableFormat(new PrintWriter(System.err));
                    continue;
                }
                if (argument.startsWith("@")) {
                    style.defaultmedium = argument;
                    continue;
                }
                if (argument.equals("css1") || argument.equals("css2") || argument.equals("css21") || argument.equals("css3") || argument.equals("svg") || argument.equals("svgbasic") || argument.equals("svgtiny")) {
                    style.cssversion = argument;
                    continue;
                }
                if (argument.equals("mobile") || argument.equals("tv")) {
                    style.profile = argument;
                    continue;
                }
                if (argument.equals("atsc")) {
                    style.profile = "atsc-tv";
                    continue;
                }
                int idx = argument.lastIndexOf(46);
                style.lang = idx >= 0 && idx < argument.length() - 1 ? argument.substring(idx + 1) : "en";
                style.documentBase = argument;
            }
            style.ac = new ApplContext(style.lang);
            if (style.cssversion != null) {
                style.ac.setCssVersion(style.cssversion);
            }
            if (style.profile != null) {
                style.ac.setProfile(style.profile);
                style.ac.setCssVersion(PropertiesLoader.config.getProperty("defaultProfile"));
            }
            if (style.cssversion == null && style.ac.getCssVersion() == null) {
                style.ac.setCssVersion(PropertiesLoader.config.getProperty("defaultProfile"));
            }
        }
        catch (Exception e) {
            System.out.println("Usage: validator  [ -s || -e || -<your format> || -cssversion/profile ] [<url>|<file>]*");
            System.out.println("\t-s\tShow the validated style sheet");
            System.out.println("\t-e\tDo NOT show warnings");
            System.out.println("\tuse the option -format to see available format.");
            System.out.println("\tCSS version\t-css1 || -css2 || -css21 || -css3 || -svg || -svgbasic || -svgtiny");
            System.out.println("\tProfile\t\t -atsc || -mobile || tv");
            System.exit(1);
        }
        String encoding = style.ac.getMsg().getString("output-encoding-name");
        style.out = encoding != null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding)) : new PrintWriter(new OutputStreamWriter(System.out));
        while (i < args.length) {
            try {
                String doc = args[i];
                try {
                    style.htmlURL = new URL(doc);
                    style.file = style.htmlURL.toString();
                }
                catch (MalformedURLException ex) {
                    File f = new File(args[i]);
                    style.file = f.getAbsolutePath();
                    style.htmlURL = new URL("file", null, -1, style.file);
                }
                ++i;
                String urlLower = style.htmlURL.toString().toLowerCase();
                if (urlLower.endsWith(".css")) {
                    style.cssRequest(selector, style.defaultmedium);
                    continue;
                }
                if (urlLower.endsWith(".html") || urlLower.endsWith(".shtml") || urlLower.endsWith("/")) {
                    style.htmlRequest();
                    continue;
                }
                if (urlLower.endsWith(".xml")) {
                    style.xmlRequest();
                    continue;
                }
                URLConnection urlC = HTTPURL.getConnection(style.htmlURL, null);
                if (urlC.getContentType() != null) {
                    MimeType mt = null;
                    try {
                        mt = new MimeType(urlC.getContentType());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (MimeType.TEXT_HTML.match(mt) == 4) {
                        style.htmlRequest();
                    } else if (MimeType.TEXT_XML.match(mt) == 4 || MimeType.APPLICATION_XHTML_XML.match(mt) == 4) {
                        style.xmlRequest();
                    } else if (MimeType.TEXT_CSS.match(mt) == 4) {
                        style.cssRequest(selector, style.defaultmedium);
                    }
                } else {
                    style.cssRequest(selector, style.defaultmedium);
                }
                try {
                    urlC.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (SAXException e) {
                if (e.getException() == null) continue;
                e.getException().printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static CssSelectors createSelectors(String s) {
        try {
            CssFouffa fouffa = new CssFouffa(null, new StringBufferInputStream(s), new URL("file://nofile"));
            return fouffa.parseSelector();
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }
}

